/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;

public class TartaricForgeProcessor
implements IComponentProcessor {
    private RecipeTartaricForge recipe;

    public void setup(IVariableProvider variables) {
        Recipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(id);
        if (recipeHandler.isPresent() && (recipe = (Recipe)recipeHandler.get()).m_6671_().equals(BloodMagicRecipeType.TARTARICFORGE.get())) {
            this.recipe = (RecipeTartaricForge)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Hellfire Forge recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.getInput().size() > index) {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().get(index).m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            return null;
        }
        switch (key) {
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
            case "willrequired": {
                return IVariable.wrap((Number)this.recipe.getMinimumSouls());
            }
            case "willdrain": {
                return IVariable.wrap((Number)this.recipe.getSoulDrain());
            }
            case "will": {
                if (this.recipe.getMinimumSouls() <= 1.0) {
                    return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get()));
                }
                if (this.recipe.getMinimumSouls() <= 64.0) {
                    return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.PETTY_GEM.get()));
                }
                if (this.recipe.getMinimumSouls() <= 256.0) {
                    return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.LESSER_GEM.get()));
                }
                if (this.recipe.getMinimumSouls() <= 1024.0) {
                    return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.COMMON_GEM.get()));
                }
                if (this.recipe.getMinimumSouls() <= 4096.0) {
                    return IVariable.from((Object)new ItemStack((ItemLike)BloodMagicItems.GREATER_GEM.get()));
                }
                LogManager.getLogger().warn("Guidebook could not find a large enough Tartaric Gem for {}", (Object)this.recipe.m_6423_());
                return IVariable.from((Object)new ItemStack((ItemLike)Items.f_42127_));
            }
        }
        return null;
    }
}

